//=============================================================================
// MyChart.js
//=============================================================================
 /*:
 * @plugindesc ステータス画面の代わりにレーダーチャート画面を表示します
 * @author TRS
 * @help ●導入前にすること
 *・このプラグインを使用する場合はjs/libs 配下に、Chart.jsを置きます（ver2.9.4で動作確認）
 *・その後、プロジェクトフォルダ内のIndexをメモ帳で開き　<script type="text/javascript" src="js/libs/Chart.js"></script> を追加する必要があります
 * 
 * ◆プラグインコマンド 
 * ・立ち絵変更 [ピクチャ名]
 *      [ピクチャ名]……img/picture内にあるピクチャファイル名を指定します（.png不要）
 *
 *  →このプラグインコマンドを実行すると、レーダーチャート画面の立ち絵ピクチャを変えることができます
 *
 * ◆備考
 * 　座標値は全て、画面内の座標値で設定します
 *
 *
 * @param vals
 * @desc レーダーチャートにする変数
 * @type variable[]
 * @default []
 *
 * @param -----チャート設定-------
 * @desc セパレータ
 *
 * @param チャートの横位置
 * @desc チャート配置横座標(初期値:0)
 * @type number
 * @default  0
 *
 * @param チャートの縦位置
 * @desc チャート配置縦座標(初期値:60)
 * @type number
 * @default  60
 *
 * @param チャートの幅
 * @desc チャートの幅(初期値:400)
 * @type number
 * @default 400
 *
 * @param チャートの高さ
 * @desc チャートの高さ(初期値:400)
 * @type number
 * @default 400
 *
 * @param チャート最大値
 * @desc チャート最大値(最低値:1)
 * @type number
 * @min 1
 * @default 10
 *
 * @param チャート目盛分割値
 * @desc チャートの区切り単位(最低値:1)
 * @type number
 * @min 1
 * @default 2
 
 * @param チャートの文字サイズ
 * @desc チャートの文字の大きさ(初期値:20)
 * @type number 
 * @default 20
 *
 * @param チャートの見出し文字色
 * @type struct<RGBA>
 *
 * @param チャートの色
 * @type struct<RGBA>
 *
 * @param チャートのグリッド部の色
 * @type struct<RGBA>
 *
 *
 * @param -----立ち絵ピクチャの設定-------
 * @desc セパレータ
 *
 * @param 初期立ち絵ファイル
 * @desc 最初に表示する立ち絵ピクチャ
 *（立ち絵はプラグインコマンドで変更可）
 * @type file
 * @require 1
 * @dir img/pictures
 *
 * @param 立ち絵ピクチャX座標
 * @desc 立ち絵ピクチャの横座標(初期値:200)
 * @type number
 * @max 9999
 * @min -9999
 * @default 200
 *
 * @param 立ち絵ピクチャY座標
 * @desc 立ち絵ピクチャの縦座標(初期値:0)
 * @type number
 * @max 9999
 * @min -9999
 * @default 0
 *
 * @param -----説明文字の表示-----
 * @decs セパレータ
 * 
 * @param 説明変数
 * @desc 変数名が説明見出しになり、変数内容が説明文章となります。
 * 改行は 改行したいところで \n をいれてください(\nは半角文字)(初期値:7)
 * @type variable
 * @default 7
 *
 * @param 説明部分文字サイズ
 * @desc 説明部分の文字サイズ(初期値:28)
 * @type number
 * @max 96
 * @min 8
 * @default 28
 *
 * @param 説明見出しX座標
 * @desc 説明見出し横座標(初期値:12)
 * @type number 
 * @min -9999
 * @max 9999
 * @default 12
 *
 * @param 説明見出しY座標
 * @desc 説明見出し縦座標(初期値:500)
 * @type number 
 * @min -9999
 * @max 9999
 * @default 500
 *
 * * @param 説明内容X座標
 * @desc 説明内容横座標(初期値:84)
 * @type number 
 * @min -9999
 * @max 9999
 * @default 84
 *
 * @param 説明内容Y座標
 * @desc 説明内容縦座標(初期値:500)
 * @type number 
 * @min -9999
 * @max 9999
 * @default 500
 *
 */
 
 
//構造体
/*~struct~RGBA:
 * @param red
 * @desc 赤色度(0～255)
 * @type number
 * @min 0
 * @max 255
 * @default 255
 *
 * @param green
 * @desc 緑色度(0～255)
 * @type number
 * @min 0
 * @max 255
 * @default 255
 *
 * @param blue
 * @desc 青色度(0～255)
 * @type number
 * @min 0
 * @max 255
 * @default 255
 *  
 * @param alpha
 * @desc 不透明度(0～255)
 * @type number
 * @min 0
 * @max 255
 * @default 255
 */
 
(function() 
{
	//ChartCanvasの作成を追加定義
	var parameters = PluginManager.parameters('MyChart');
	var lstVals = JSON.parse(parameters.vals);
	
	var varChartXpos = Number(parameters['チャートの横位置'] || 0);
	var varChartYpos = Number(parameters['チャートの縦位置'] || 60);
	
	var varChartWidth = Number(parameters['チャートの幅'] || 400 );
	var varChartHeight = Number(parameters['チャートの高さ'] || 400 );
	var varChartFontSize = Number(parameters['チャートのフォントサイズ'] || 20 );
	var varChartMax = Number(parameters['チャート最大値'] || 10 );
	var varChartGrid = Number(parameters['チャート目盛分割値'] || 2 );
	
	var varPicName = String ( parameters['初期立ち絵ファイル']  );
	var varPicPosX = Number ( parameters['立ち絵ピクチャX座標'] || 200 );
	var varPicPosY = Number ( parameters['立ち絵ピクチャY座標'] || 0 );
	
	var strLblColor = JSON.parse(parameters['チャートの見出し文字色']);
	var strChartColor = JSON.parse(parameters['チャートの色']);
	var strGridColor = JSON.parse(parameters['チャートのグリッド部の色']);
	
	var varExpVal = Number( parameters['説明変数'] || 1 );
	var varExpFontSize = Number( parameters['説明部分文字サイズ'] || 28);
	var varExplblXpos = Number( parameters['説明見出しX座標'] || 12 );
	var varExplblYpos = Number( parameters['説明見出しY座標'] || 500 );
	
	var varExpMainXpos = Number( parameters['説明内容X座標'] || 84 );
	var varExpMainYpos = Number( parameters['説明内容Y座標'] || 500 );
	
	//-----------------------------------------------------------------------------
	/**
	 * The static class that carries out graphics processing.
	 *
	 * @class Graphics
	 */
	 
	var _graphics_createAllElement = Graphics._createAllElements;
	Graphics._createAllElements = function () 
	{
	   _graphics_createAllElement.call(this);
	    this._createChartCanvas();
	};

	var graphics_updateAllElements = Graphics._updateAllElements;
	//ChartCanvasの更新を追加定義
	Graphics._updateAllElements = function () 
	{
	 	graphics_updateAllElements.call(this);
	 	
	    this._updateChartCanvas();
	    
	};

	//ChartCanvasの作成メソッドを新規作成
	Graphics._createChartCanvas = function () 
	{
	    this._chartCanvas = document.createElement('canvas');
	    this._chartCanvas.id = 'ChartCanvas';
	    this._updateChartCanvas();
	    document.body.appendChild(this._chartCanvas);
	};

	//ChartCanvasの更新メソッドを新規作成
	Graphics._updateChartCanvas = function () 
	{
	    this._chartCanvas.width = 0;
	    this._chartCanvas.height = 0;
	    this._chartCanvas.style.zIndex = 5;
	    this._chartCanvas.style.opacity = 0;
	};
	
	//グラフを削除するメソッドを新規作成
	Graphics._clearChartCanvas = function () 
	{
	    if (MyChart != null) MyChart.destroy()
	    var context = this._chartCanvas.getContext('2d');
	    context.canvas.style.opacity = 0
	    context.clearRect(context.canvas.style.left, context.canvas.style.top, context.canvas.width, context.canvas.height);
	};
	
	var graphics_createAllElements = Graphics._createAllElements;
	//ChartCanvasの作成を追加定義
	Graphics._createAllElements = function () 
	{
	    graphics_createAllElements.call(this);
	    
	    this._createChartCanvas();   //追加
	};
	
	//-----------------------------------------------------------------------------
	// Window_Status
	//
	// The window for displaying full status on the status screen.
	//グラフの値とラベルを取得するよう書き換え
	Window_Status.prototype.drawParameters = function (x, y) {
	    var chart = MyChartData.data
	    chart.labels = [];
	    chart.datasets[0].data = [];
	    
	    console.log( lstVals );
	    
	    /*描画サンプル
	    for (var i = 0; i < 6; i++) 
	    {
	        var paramId = i + 2;
	        console.log( TextManager.param(paramId) );
	        chart.labels.push(TextManager.param(paramId));
	        chart.datasets[0].data.push(this._actor.param(paramId));
	    }
	    */
	    
	    //指定してる変数分チャートに設定
	    for( var i = 0; i < lstVals.length; i++ )
	    {
			chart.labels.push( $dataSystem.variables[ lstVals[i] ] );
			chart.datasets[0].data.push( Number( $gameVariables.value( lstVals[i] ) ) );
	    }
	    
	    
	};
	
	/**
	 * スペースを出さないようにする
	 */
	
	Window_Status.prototype.standardPadding = function() 
	{
    	return 0;
	};
	
	Window_Status.prototype.refresh = function() 
	{
	    this.contents.clear();
	    if (this._actor) 
	    {
	        var lineHeight = this.lineHeight();
	        this.drawBlock1(lineHeight * 0);
	        this.drawHorzLine(lineHeight * 1);
	        //this.drawBlock2(lineHeight * 2);
	        //this.drawHorzLine(lineHeight * 6);
	        this.drawBlock3(lineHeight * 6 );
	        //this.drawHorzLine(lineHeight * 13);
	        //this.drawBlock4(lineHeight * 14);
	        //createChartObj(lineHeight * 6.5);   //追加
	        
	        createChartObj(lineHeight * 6);   //追加
	        
	    }
	    this.drawStandPicture();
	    this.drawExplanation();
	};

	/**
	 * 1ブロック目名前だけにする
	 */
	
	Window_Status.prototype.drawBlock1 = function(y) 
	{
	    this.drawActorName(this._actor, 6 + 18, y + 9);
	    //this.drawActorClass(this._actor, 192, y);
	    //this.drawActorNickname(this._actor, 432, y);
	};
	
	/**
	 * 3ブロック目パラメータだけにする
	 */
	 
	Window_Status.prototype.drawBlock3 = function(y) 
	{
	    this.drawParameters(48, y);
	    //this.drawEquipments(432, y);
	};
	
	/**
	 * 立ち絵表示
	 */
	
	Window_Status.prototype.drawStandPicture = function()
	{
		//console.log( rgbInfoConvert(strLblColor) )
		this.drawPicture(varPicName, varPicPosX, varPicPosY);				//吹き出しピクチャ1描画
	}
	/**
	 *　イラスト描画
	 */
	
	Window_Status.prototype.drawPicture = function(picName, xPos, yPos)
	{
		var bitmap;
		
		bitmap = ImageManager.loadPicture(picName);		//ウィンドウに描画するピクチャ描画
		
		var OffsetX = xPos;
		var OffsetY = yPos;
		
		//sx 開始X座標(ピクチャの描画を開始するX座標(-はNG) 基本的に0でいいかも)
		//sy 開始Y座標(ピクチャの描画を開始するY座標(-はNG) 基本的に0でいいかも)
		//Sw 幅？(描画範囲W)
		//Sh 高さ?（描画範囲h）
		//dx ずらすX座標
		//dy ずらすY座標
		
		//var sw = 816;
		//var sh = 624;
		//var dx = 0;
		//var dy = 0 + 624;
		//var sx = bitmap.width / 2 - 816 / 2 - OffsetX;
		//var sy = OffsetY;
		
		console.log(bitmap);
		
		this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, OffsetX, OffsetY);
	};
	
	/**
	 * 説明描画
	 */
	Window_Status.prototype.drawExplanation = function()
	{
		wrkOriginal_fontSize = this.contents.fontSize;														//基本値キープ
		this.contents.fontSize = varExpFontSize;															//変更値設定
		this.drawText( $dataSystem.variables[ varExpVal ] + ":", varExplblXpos, varExplblYpos, Graphics.width);		//ラベル描画
		
		var wrk = String( $gameVariables.value( varExpVal ) ).split('\n');										//\nを改行として区切る
		console.log(wrk);
		
		for( var i = 0; i < wrk.length; i++)
		{
			this.drawText( wrk[i], varExpMainXpos, varExpMainYpos + (this.contents.fontSize * i), Graphics.width);		//本文描画
		}
		
		this.contents.fontSize = wrkOriginal_fontSize;														//基本値戻す
	}
	
	//-----------------------------------------------------------------------------
	// Window_Selectable
	//
	// The window class with cursor movement and scroll functions.
	
	//グラフの削除を追加定義
	Window_Selectable.prototype.activate = function () {
	    Window_Base.prototype.activate.call(this);
	    this.reselect();
	    Graphics._clearChartCanvas();  //追加
	};
	
	//-----------------------------------------------------------------------------
	// チャート定義
	//
	//ChartCanvasの体裁を整えてグラフを描画するメソッドを新規作成
	var MyChart = null;
	createChartObj = function (y) {
	    var context = document.getElementById('ChartCanvas').getContext('2d');
	    //context.canvas.width = 350;
	    //context.canvas.height = 350;
	    
	    context.canvas.width = varChartWidth;
	    context.canvas.height = varChartHeight;
	    
	    context.canvas.style.position = 'relative';
	    context.canvas.style.margin = 0;
	    
	    //context.canvas.style.left = Graphics._canvas.offsetLeft + 'px';
	    //context.canvas.style.top = Graphics._canvas.offsetTop + y + 'px';
	    
	    context.canvas.style.left = (Graphics._canvas.offsetLeft + varChartXpos) + 'px';
	    context.canvas.style.top = (Graphics._canvas.offsetTop + varChartYpos) + 'px';
	    
	    context.canvas.style.opacity = 1;
	    
	    MyChart = new Chart(context, MyChartData);
	}
	
	//以下チャートの定義
	var MyChartData = {
	    //グラフの種類
	    type: 'radar',
	    //データの設定
	    data: 
	    {
	        //データ項目のラベル
	        labels: [],
	        //データセット
	        datasets: [
	            {
	                //線のカーブ
	                lineTension: 0,
	                //例
	                label: '',
	                //面の表示
	                fill: true,
	                //背景色
	                //backgroundColor: 'rgba(250,241,109,0.5)',
	                backgroundColor: 'rgba(' + strChartColor.red + ',' + strChartColor.green + ',' + strChartColor.blue + ',' +  (strChartColor.alpha / 255 ) + ')', 			//色変え設定はここでやらないと動かない！
	                
	                //枠線の色(チャートのアウトライン)
	                borderColor: 'rgba(128,0,128,0)', //'rgba(250,241,109,0)',
	                //結合点の背景色と数値	//数値の色が一緒なのが納得いかない……
	                pointBackgroundColor: 'rgba(250,241,109,0)',
	                //枠線の太さ(どこ？)
	                borderWidth: 0,
	                //線の色(どこ？)
	                strokeColor: 'rgba(255,255,255,1)',
	                //値の点の枠線の色(どこ？)
	                pointStrokeColor: 'rgba(255,255,255,1)',
	                //背景色（ホバーしたときに）
	                //hoverBackgroundColor: 'rgba(179,181,198,0.4)',
	                //結合点より外でマウスホバーを認識する範囲（ピクセル単位）
	                pointHitRadius: '100px',
	                //グラフのデータ
	                data: []
	            }
	        ]
	    },
	    //オプションの設定
	    options: {
	        //グラフ外側の文字色(どこ？)
	        scaleFontColor: 'rgba((255,0,0,1)',
	        //サイズ自動調整
	        responsive: false,
	        //ボーダーライン幅
	        borderWidth: 2,
	        //スケール
	        scale: 
	        {
	            //タイプ
	            type: 'radialLinear',
	            //フォントサイズ
	            fontSize: 0,
	            //ボーダー色（どこ？）
	            borderColor: 'rgba(0,0,0,0)',
	            //ポイントラベル
	            pointLabels: 
	            {
	                //フォントサイズ
	                //fontSize: 10,
	                fontSize: varChartFontSize,
	                //フォントカラー
	                //fontColor: 'rgba(255,255,255,1)'
	                fontColor: 'rgba(' + strLblColor.red + ',' + strLblColor.green + ',' + strLblColor.blue + ',' +  (strLblColor.alpha / 255 ) + ')', 			//色変え設定はここでやらないと動かない！
	            },
	            
	            //目盛
	            ticks: 
	            {
	                //間隔
	                stepSize: varChartGrid,
	                //最大値
	                max: varChartMax,
	                //最低値がゼロ
	                beginAtZero: true,
	                //ラベル表示
	                showLabels: true,
	                //フォントカラー（どこ？）
	                fontColor: 'rgba((255,0,0,1)',
	                //フォントサイズ
	                fontSize: 10,
	                //ラベルバックドロップ表示
	                showLabelBackdrop: false,
	            },
	            
	            //グリッドライン
	            gridLines:
	            {
	            	display:!0,
	            	color: 'rgba(' + strGridColor.red + ',' + strGridColor.green + ',' + strGridColor.blue + ',' +  (strGridColor.alpha / 255 ) + ')' ,			//色変え設定はここでやらないと動かない！,
	            },
	            
	            //アングルライン
	            angleLines:
	            {
	            	display:!0,
	            	color: 'rgba(' + strGridColor.red + ',' + strGridColor.green + ',' + strGridColor.blue + ',' +  (strGridColor.alpha / 255 ) + ')' ,			//色変え設定はここでやらないと動かない！
	            }
	        },
	        //凡例
	        legend: {
	            //非表示
	            display: false
	        },
	        //ホバー
	        hover: {
	            //動作（single, label, dataset）
	            mode: 'label'
	        }
	    }
	};
	
	/**
	 * rgba文字へ変換
	 */
	
	rgbInfoConvert = function( struct )
	{
		return ret = "";
	}
	
	/**
	 * インタプリタ
	 */
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args)
	{
		_Game_Interpreter_pluginCommand.call(this, command, args);
		if( command == '立ち絵変更' )
		{
			varPicName = args[0];
		}
		
	}
	
})();
